/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.client.screen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.angel.challenges6t4.challenge.challenges.CantTouchAnythingChallenge;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class CantTouchAnythingOptionsScreen
extends class_437 {
    private final class_437 parent;
    private final CantTouchAnythingChallenge challenge;
    private class_342 forbiddenField;
    private List<String> suggestions = new ArrayList<String>();
    private List<String> filteredSuggestions = new ArrayList<String>();
    private int selectedSuggestion = -1;
    private boolean showSuggestions = false;
    private int feedbackTimer = 0;
    private String feedbackMessage = "";
    private static final String PRESET_FOLDER = "config/presets/cant_touch_anything";
    private boolean showPresetDialog = false;
    private boolean isSavingPreset = false;
    private class_342 presetNameField;
    private List<String> availablePresets = new ArrayList<String>();
    private int selectedPreset = -1;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private class_4185 loadButton;
    private float scrollPosition = 0.0f;
    private boolean isDragging = false;
    private static final int ENTRY_HEIGHT = 24;
    private static final int ENTRY_SPACING = 2;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int LIST_HEADER_HEIGHT = 30;
    private static final int LIST_FOOTER_HEIGHT = 10;

    public CantTouchAnythingOptionsScreen(class_437 parent, CantTouchAnythingChallenge challenge) {
        super((class_2561)class_2561.method_43470((String)"Cant Touch Anything Options"));
        this.parent = parent;
        this.challenge = challenge;
        this.loadSuggestions();
    }

    private void loadSuggestions() {
        String path;
        class_2960 id;
        this.suggestions.clear();
        for (class_2248 block : class_7923.field_41175) {
            id = class_7923.field_41175.method_10221((Object)block);
            if (!id.method_12836().equals("minecraft") || this.suggestions.contains(path = id.method_12832())) continue;
            this.suggestions.add(path);
        }
        for (class_1792 item : class_7923.field_41178) {
            id = class_7923.field_41178.method_10221((Object)item);
            if (!id.method_12836().equals("minecraft") || this.suggestions.contains(path = id.method_12832())) continue;
            this.suggestions.add(path);
        }
        for (class_1299 entityType : class_7923.field_41177) {
            id = class_7923.field_41177.method_10221((Object)entityType);
            if (!id.method_12836().equals("minecraft") || this.suggestions.contains(path = id.method_12832())) continue;
            this.suggestions.add(path);
        }
        this.suggestions.sort(String::compareToIgnoreCase);
    }

    private void updateSuggestions(String input) {
        this.filteredSuggestions.clear();
        this.selectedSuggestion = -1;
        if (input.isEmpty()) {
            this.showSuggestions = false;
            return;
        }
        String[] parts = input.split(",");
        if (parts.length == 0) {
            this.showSuggestions = false;
            return;
        }
        String currentWord = parts[parts.length - 1].trim().toLowerCase();
        if (currentWord.isEmpty()) {
            this.showSuggestions = false;
            return;
        }
        for (String suggestion : this.suggestions) {
            if (!suggestion.toLowerCase().startsWith(currentWord)) continue;
            this.filteredSuggestions.add(suggestion);
        }
        this.showSuggestions = !this.filteredSuggestions.isEmpty();
    }

    private List<String> getForbiddenItemsList() {
        String items = this.challenge.getForbiddenItems();
        if (items.isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.stream(items.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private void addCurrentEntry() {
        String currentText = this.forbiddenField.method_1882().trim();
        if (!currentText.isEmpty()) {
            List<String> currentItems = this.getForbiddenItemsList();
            if (!currentItems.contains(currentText)) {
                currentItems.add(currentText);
                String newItems = String.join((CharSequence)",", currentItems);
                this.challenge.setForbiddenItems(newItems);
                this.forbiddenField.method_1852("");
                this.updateSuggestions("");
                this.feedbackMessage = "Added: " + currentText;
                this.feedbackTimer = 60;
            } else {
                this.feedbackMessage = "Already in list: " + currentText;
                this.feedbackTimer = 60;
            }
        }
    }

    private void removeEntry(String itemToRemove) {
        List<String> currentItems = this.getForbiddenItemsList();
        currentItems.remove(itemToRemove);
        String newItems = String.join((CharSequence)",", currentItems);
        this.challenge.setForbiddenItems(newItems);
    }

    private int getTotalListHeight() {
        return this.getForbiddenItemsList().size() * 26;
    }

    private int getMaxScroll() {
        int contentHeight = this.getTotalListHeight();
        int visibleHeight = this.field_22790 - 30 - 10 - 140;
        return Math.max(0, contentHeight - visibleHeight);
    }

    private void selectSuggestion(int index) {
        if (index >= 0 && index < this.filteredSuggestions.size()) {
            this.selectedSuggestion = index;
        }
    }

    private void applySelectedSuggestion() {
        if (this.selectedSuggestion >= 0 && this.selectedSuggestion < this.filteredSuggestions.size()) {
            String selected = this.filteredSuggestions.get(this.selectedSuggestion);
            String currentText = this.forbiddenField.method_1882();
            CharSequence[] parts = currentText.split(",");
            if (parts.length > 0) {
                parts[parts.length - 1] = selected;
                String newText = String.join((CharSequence)",", parts);
                this.forbiddenField.method_1852(newText);
            }
            this.showSuggestions = false;
            this.selectedSuggestion = -1;
        }
    }

    private void ensurePresetFolderExists() {
        try {
            Path folderPath = Paths.get(PRESET_FOLDER, new String[0]);
            if (!Files.exists(folderPath, new LinkOption[0])) {
                Files.createDirectories(folderPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create preset folder: " + e.getMessage());
        }
    }

    private void loadAvailablePresets() {
        this.availablePresets.clear();
        try {
            Path folderPath = Paths.get(PRESET_FOLDER, new String[0]);
            if (Files.exists(folderPath, new LinkOption[0])) {
                Files.list(folderPath).filter(path -> path.toString().endsWith(".json")).map(path -> path.getFileName().toString().replace(".json", "")).forEach(this.availablePresets::add);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load presets: " + e.getMessage());
        }
        this.availablePresets.sort(String::compareToIgnoreCase);
    }

    private void savePreset(String presetName) {
        try {
            this.ensurePresetFolderExists();
            Path filePath = Paths.get(PRESET_FOLDER, presetName + ".json");
            List<String> items = this.getForbiddenItemsList();
            if (items.isEmpty()) {
                this.feedbackMessage = "No forbidden entries to save!";
                this.feedbackTimer = 60;
                return;
            }
            String content = String.join((CharSequence)"\n", items);
            Files.write(filePath, content.getBytes(), new OpenOption[0]);
            this.feedbackMessage = "Preset saved: " + presetName;
            this.feedbackTimer = 60;
            this.showPresetDialog = false;
            this.isSavingPreset = false;
        }
        catch (IOException e) {
            this.feedbackMessage = "Failed to save preset: " + e.getMessage();
            this.feedbackTimer = 60;
        }
    }

    private void loadPreset(String presetName) {
        try {
            Path filePath = Paths.get(PRESET_FOLDER, presetName + ".json");
            if (!Files.exists(filePath, new LinkOption[0])) {
                this.feedbackMessage = "Preset not found: " + presetName;
                this.feedbackTimer = 60;
                return;
            }
            String content = Files.readString(filePath);
            String[] lines = content.split("\n");
            ArrayList<String> items = new ArrayList<String>();
            for (String line : lines) {
                String trimmed = line.trim();
                if (trimmed.isEmpty()) continue;
                items.add(trimmed);
            }
            if (!items.isEmpty()) {
                String newItems = String.join((CharSequence)",", items);
                this.challenge.setForbiddenItems(newItems);
                this.feedbackMessage = "Preset loaded: " + presetName + " (" + items.size() + " entries)";
                this.feedbackTimer = 60;
            } else {
                this.feedbackMessage = "Preset is empty: " + presetName;
                this.feedbackTimer = 60;
            }
            this.showPresetDialog = false;
            this.selectedPreset = -1;
        }
        catch (IOException e) {
            this.feedbackMessage = "Failed to load preset: " + e.getMessage();
            this.feedbackTimer = 60;
        }
    }

    private void showSavePresetDialog() {
        this.showPresetDialog = true;
        this.isSavingPreset = true;
        this.selectedPreset = -1;
        int dialogWidth = 400;
        int dialogHeight = 150;
        int dialogX = (this.field_22789 - dialogWidth) / 2;
        int dialogY = (this.field_22790 - dialogHeight) / 2;
        this.presetNameField = new class_342(this.field_22793, dialogX + 10, dialogY + 55, dialogWidth - 20, 20, (class_2561)class_2561.method_43470((String)"Preset Name"));
        this.presetNameField.method_1852("");
        this.presetNameField.method_1880(50);
        this.presetNameField.method_25365(true);
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> {
            if (this.presetNameField != null && !this.presetNameField.method_1882().trim().isEmpty()) {
                this.savePreset(this.presetNameField.method_1882().trim());
                this.showPresetDialog = false;
                this.presetNameField = null;
            }
        }).method_46434(dialogX + 10, dialogY + 80, 80, 20).method_46431();
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> {
            this.showPresetDialog = false;
            this.presetNameField = null;
        }).method_46434(dialogX + 100, dialogY + 80, 80, 20).method_46431();
    }

    private void showLoadPresetDialog() {
        this.showPresetDialog = true;
        this.isSavingPreset = false;
        this.loadAvailablePresets();
        this.selectedPreset = -1;
        int dialogWidth = 400;
        int maxPresets = Math.min(10, this.availablePresets.size());
        int minHeight = 200;
        int listHeight = maxPresets * 20 + 40;
        int dialogHeight = Math.max(minHeight, listHeight + 80);
        int dialogX = (this.field_22789 - dialogWidth) / 2;
        int dialogY = (this.field_22790 - dialogHeight) / 2;
        int buttonWidth = 80;
        int buttonSpacing = 20;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = dialogX + (dialogWidth - totalButtonWidth) / 2;
        this.loadButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Load"), button -> {
            if (this.selectedPreset >= 0 && this.selectedPreset < this.availablePresets.size()) {
                this.loadPreset(this.availablePresets.get(this.selectedPreset));
            }
        }).method_46434(buttonStartX, dialogY + dialogHeight - 40, buttonWidth, 20).method_46431();
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> {
            this.showPresetDialog = false;
            this.selectedPreset = -1;
        }).method_46434(buttonStartX + buttonWidth + buttonSpacing, dialogY + dialogHeight - 40, buttonWidth, 20).method_46431();
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431());
        this.forbiddenField = new class_342(this.field_22793, 20, 60, this.field_22789 - 100, 20, (class_2561)class_2561.method_43470((String)"Add Forbidden Entry..."));
        this.forbiddenField.method_1852("");
        this.forbiddenField.method_1863(text -> this.updateSuggestions((String)text));
        this.method_25429((class_364)this.forbiddenField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), button -> this.addCurrentEntry()).method_46434(this.field_22789 - 70, 60, 50, 20).method_46431());
        int buttonWidth = 100;
        int buttonSpacing = 20;
        int totalWidth = buttonWidth * 2 + buttonSpacing;
        int startX = (this.field_22789 - totalWidth) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save Preset"), button -> this.showSavePresetDialog()).method_46434(startX, 90, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Load Preset"), button -> this.showLoadPresetDialog()).method_46434(startX + buttonWidth + buttonSpacing, 90, buttonWidth, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1072689136);
        if (this.feedbackTimer > 0) {
            --this.feedbackTimer;
        }
        if (!this.showPresetDialog) {
            this.renderStaticText(context, mouseX, mouseY);
            this.renderForbiddenItemsList(context, mouseX, mouseY);
            super.method_25394(context, mouseX, mouseY, delta);
            this.forbiddenField.method_25394(context, mouseX, mouseY, delta);
            this.renderFeedbackMessage(context, mouseX, mouseY);
            if (this.showSuggestions && !this.filteredSuggestions.isEmpty()) {
                int maxSuggestions = Math.min(10, this.filteredSuggestions.size());
                int suggestionHeight = 12;
                int totalHeight = maxSuggestions * suggestionHeight;
                int suggestionX = this.forbiddenField.method_46426();
                int suggestionY = this.forbiddenField.method_46427() + this.forbiddenField.method_25364() + 2;
                context.method_25294(suggestionX, suggestionY, suggestionX + this.forbiddenField.method_25368(), suggestionY + totalHeight, -16777216);
                context.method_25294(suggestionX + 1, suggestionY + 1, suggestionX + this.forbiddenField.method_25368() - 1, suggestionY + totalHeight - 1, -14671840);
                for (int i = 0; i < maxSuggestions; ++i) {
                    boolean hovered;
                    String suggestion = this.filteredSuggestions.get(i);
                    int suggestionYPos = suggestionY + i * suggestionHeight + 2;
                    boolean bl = hovered = mouseX >= suggestionX + 2 && mouseX <= suggestionX + this.forbiddenField.method_25368() - 2 && mouseY >= suggestionYPos && mouseY <= suggestionYPos + suggestionHeight;
                    int color = i == this.selectedSuggestion ? -256 : (hovered ? -5592406 : -1);
                    context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)suggestion), suggestionX + 2, suggestionYPos, color);
                }
            }
        }
        if (this.showPresetDialog) {
            this.renderPresetDialog(context, mouseX, mouseY);
        }
    }

    private void renderPresetDialog(class_332 context, int mouseX, int mouseY) {
        int dialogHeight;
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        int dialogWidth = 400;
        if (this.isSavingPreset) {
            dialogHeight = 150;
        } else {
            int maxPresets = Math.min(10, this.availablePresets.size());
            int minHeight = 200;
            int listHeight = maxPresets * 20 + 40;
            dialogHeight = Math.max(minHeight, listHeight + 80);
        }
        int dialogX = (this.field_22789 - dialogWidth) / 2;
        int dialogY = (this.field_22790 - dialogHeight) / 2;
        context.method_25294(dialogX, dialogY, dialogX + dialogWidth, dialogY + dialogHeight, -14671840);
        context.method_25294(dialogX + 1, dialogY + 1, dialogX + dialogWidth - 1, dialogY + dialogHeight - 1, -12566464);
        String titleText = this.isSavingPreset ? "Save Preset" : "Load Preset";
        int titleWidth = this.field_22793.method_1727(titleText);
        context.method_51433(this.field_22793, titleText, dialogX + (dialogWidth - titleWidth) / 2, dialogY + 10, -256, false);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)titleText), dialogX + dialogWidth / 2, dialogY + 10, 0xFFFFFF);
        if (this.isSavingPreset) {
            context.method_51433(this.field_22793, "Preset Name:", dialogX + 10, dialogY + 40, -256, false);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Preset Name:"), dialogX + 10, dialogY + 40, -1118482);
            if (this.presetNameField != null) {
                this.presetNameField.method_25394(context, mouseX, mouseY, 0.0f);
            }
            if (this.saveButton != null) {
                this.saveButton.method_25394(context, mouseX, mouseY, 0.0f);
            }
            if (this.cancelButton != null) {
                this.cancelButton.method_25394(context, mouseX, mouseY, 0.0f);
            }
        } else {
            context.method_51433(this.field_22793, "Available Presets:", dialogX + 10, dialogY + 40, -256, false);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Available Presets:"), dialogX + 10, dialogY + 40, 0xCCCCCC);
            int listY = dialogY + 60;
            int maxPresets = Math.min(10, this.availablePresets.size());
            for (int i = 0; i < maxPresets; ++i) {
                boolean selected;
                int y = listY + i * 20;
                String preset = this.availablePresets.get(i);
                boolean hovered = mouseX >= dialogX + 10 && mouseX <= dialogX + dialogWidth - 10 && mouseY >= y && mouseY <= y + 18;
                boolean bl = selected = i == this.selectedPreset;
                int bgColor = selected ? -11184726 : (hovered ? -12303292 : -13421773);
                context.method_25294(dialogX + 10, y, dialogX + dialogWidth - 10, y + 18, bgColor);
                Objects.requireNonNull(this.field_22793);
                int textY = y + (18 - 9) / 2;
                context.method_25303(this.field_22793, preset, dialogX + 15, textY, -1);
            }
            if (this.availablePresets.isEmpty()) {
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"No presets found"), dialogX + 15, listY + 5, -7829368);
            }
            if (this.loadButton != null) {
                this.loadButton.method_25394(context, mouseX, mouseY, 0.0f);
            }
            if (this.cancelButton != null) {
                this.cancelButton.method_25394(context, mouseX, mouseY, 0.0f);
            }
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = this.getMaxScroll();
        this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition - (float)(verticalAmount * 20.0)), (float)0.0f, (float)maxScroll);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.isDragging) {
            int maxScroll = this.getMaxScroll();
            int visibleHeight = this.field_22790 - 10 - 150;
            int contentHeight = this.getTotalListHeight();
            float scrollAmount = (float)(deltaY * (double)maxScroll) / (float)(visibleHeight - Math.max(32, (int)((float)visibleHeight / (float)contentHeight * (float)visibleHeight)));
            this.scrollPosition = class_3532.method_15363((float)(this.scrollPosition + scrollAmount), (float)0.0f, (float)maxScroll);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.showPresetDialog) {
                int dialogHeight;
                int dialogWidth = 400;
                if (this.isSavingPreset) {
                    dialogHeight = 150;
                } else {
                    int maxPresets = Math.min(10, this.availablePresets.size());
                    int minHeight = 200;
                    int listHeight = maxPresets * 20 + 40;
                    dialogHeight = Math.max(minHeight, listHeight + 80);
                }
                int dialogX = (this.field_22789 - dialogWidth) / 2;
                int dialogY = (this.field_22790 - dialogHeight) / 2;
                if (this.isSavingPreset) {
                    if (this.saveButton != null && this.saveButton.method_25402(mouseX, mouseY, button)) {
                        return true;
                    }
                    if (this.cancelButton != null && this.cancelButton.method_25402(mouseX, mouseY, button)) {
                        return true;
                    }
                } else {
                    if (this.loadButton != null && this.loadButton.method_25402(mouseX, mouseY, button)) {
                        return true;
                    }
                    if (this.cancelButton != null && this.cancelButton.method_25402(mouseX, mouseY, button)) {
                        return true;
                    }
                }
                if (!this.isSavingPreset) {
                    int listY = dialogY + 60;
                    int maxPresets = Math.min(10, this.availablePresets.size());
                    for (int i = 0; i < maxPresets; ++i) {
                        int y = listY + i * 20;
                        if (!(mouseX >= (double)(dialogX + 10)) || !(mouseX <= (double)(dialogX + dialogWidth - 10)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 18))) continue;
                        this.selectedPreset = i;
                        return true;
                    }
                }
                return true;
            }
            int scrollbarX = this.field_22789 - 6 - 4;
            int scrollbarY = 140;
            int scrollbarHeight = this.field_22790 - 10 - 140;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                this.isDragging = true;
                return true;
            }
            if (this.showSuggestions && !this.filteredSuggestions.isEmpty()) {
                int clickedIndex;
                int suggestionX = this.forbiddenField.method_46426();
                int suggestionY = this.forbiddenField.method_46427() + this.forbiddenField.method_25364() + 2;
                int suggestionHeight = 12;
                int maxSuggestions = Math.min(10, this.filteredSuggestions.size());
                if (mouseX >= (double)suggestionX && mouseX <= (double)(suggestionX + this.forbiddenField.method_25368()) && mouseY >= (double)suggestionY && mouseY <= (double)(suggestionY + maxSuggestions * suggestionHeight) && (clickedIndex = (int)((mouseY - (double)suggestionY) / (double)suggestionHeight)) >= 0 && clickedIndex < this.filteredSuggestions.size()) {
                    this.selectedSuggestion = clickedIndex;
                    this.applySelectedSuggestion();
                    return true;
                }
            }
            List<String> items = this.getForbiddenItemsList();
            int listY = 140;
            for (int i = 0; i < items.size(); ++i) {
                int y = listY + i * 26 - (int)this.scrollPosition;
                if (y < listY || y >= this.field_22790 - 10) continue;
                int removeX = this.field_22789 - 30;
                int removeY = y + 2;
                if (!(mouseX >= (double)removeX) || !(mouseX <= (double)(removeX + 20)) || !(mouseY >= (double)removeY) || !(mouseY <= (double)(removeY + 20))) continue;
                this.removeEntry(items.get(i));
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.showPresetDialog) {
            if (keyCode == 256) {
                this.showPresetDialog = false;
                this.isSavingPreset = false;
                this.selectedPreset = -1;
                return true;
            }
            if (this.isSavingPreset && this.presetNameField != null) {
                if (keyCode == 257) {
                    if (!this.presetNameField.method_1882().trim().isEmpty()) {
                        this.savePreset(this.presetNameField.method_1882().trim());
                    }
                    return true;
                }
                if (this.presetNameField.method_25404(keyCode, scanCode, modifiers)) {
                    return true;
                }
            } else if (!this.isSavingPreset) {
                if (keyCode == 264) {
                    this.selectedPreset = this.selectedPreset < this.availablePresets.size() - 1 ? ++this.selectedPreset : 0;
                    return true;
                }
                if (keyCode == 265) {
                    this.selectedPreset = this.selectedPreset > 0 ? --this.selectedPreset : this.availablePresets.size() - 1;
                    return true;
                }
                if (keyCode == 257) {
                    if (this.selectedPreset >= 0 && this.selectedPreset < this.availablePresets.size()) {
                        this.loadPreset(this.availablePresets.get(this.selectedPreset));
                    }
                    return true;
                }
            }
            return true;
        }
        if (this.showSuggestions) {
            if (keyCode == 256) {
                this.showSuggestions = false;
                this.selectedSuggestion = -1;
                return true;
            }
            if (keyCode == 264) {
                this.selectedSuggestion = this.selectedSuggestion < this.filteredSuggestions.size() - 1 ? ++this.selectedSuggestion : 0;
                return true;
            }
            if (keyCode == 265) {
                this.selectedSuggestion = this.selectedSuggestion > 0 ? --this.selectedSuggestion : this.filteredSuggestions.size() - 1;
                return true;
            }
            if (keyCode == 257) {
                this.applySelectedSuggestion();
                return true;
            }
        }
        if (this.forbiddenField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 258 && this.showSuggestions && !this.filteredSuggestions.isEmpty()) {
            this.applySelectedSuggestion();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.showPresetDialog && this.isSavingPreset && this.presetNameField != null && this.presetNameField.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.forbiddenField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    private void renderStaticText(class_332 context, int mouseX, int mouseY) {
        int titleWidth = this.field_22793.method_1727("Cant Touch Anything Options");
        context.method_51433(this.field_22793, "Cant Touch Anything Options", this.field_22789 / 2 - titleWidth / 2, 10, -1118482, false);
        String helpText = "Type an item/block/mob ID and click Add to add it to the forbidden list";
        int helpWidth = this.field_22793.method_1727(helpText);
        int helpX = (this.field_22789 - helpWidth) / 2;
        int helpY = 30;
        context.method_25294(helpX - 5, helpY - 2, helpX + helpWidth + 5, helpY + 12, Integer.MIN_VALUE);
        context.method_51433(this.field_22793, helpText, helpX, helpY, -3355444, false);
    }

    private void renderFeedbackMessage(class_332 context, int mouseX, int mouseY) {
        if (this.feedbackTimer > 0) {
            int color = this.feedbackMessage.startsWith("Added:") || this.feedbackMessage.startsWith("Preset") ? -11141291 : -43691;
            int messageWidth = this.field_22793.method_1727(this.feedbackMessage);
            context.method_51433(this.field_22793, this.feedbackMessage, this.field_22789 / 2 - messageWidth / 2, this.field_22790 - 50, color, false);
        }
    }

    private void renderForbiddenItemsList(class_332 context, int mouseX, int mouseY) {
        int listY;
        List<String> items = this.getForbiddenItemsList();
        int visibleTop = listY = 140;
        int visibleBottom = this.field_22790 - 10;
        int visibleHeight = visibleBottom - visibleTop;
        int contentHeight = this.getTotalListHeight();
        int maxScroll = this.getMaxScroll();
        this.scrollPosition = class_3532.method_15363((float)this.scrollPosition, (float)0.0f, (float)maxScroll);
        for (int i = 0; i < items.size(); ++i) {
            int y = listY + i * 26 - (int)this.scrollPosition;
            if (y + 24 < visibleTop || y > visibleBottom) continue;
            context.method_25294(20, y, this.field_22789 - 40, y + 24, -12303292);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)items.get(i)), 25, y + 4, -1);
            int removeX = this.field_22789 - 30;
            int removeY = y + 2;
            boolean hovered = mouseX >= removeX && mouseX <= removeX + 20 && mouseY >= removeY && mouseY <= removeY + 20;
            int removeColor = hovered ? -39322 : -48060;
            context.method_25294(removeX, removeY, removeX + 20, removeY + 20, removeColor);
            int xWidth = this.field_22793.method_1727("\u00d7");
            class_5250 class_52502 = class_2561.method_43470((String)"\u00d7");
            int n = removeX + (20 - xWidth) / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27535(this.field_22793, (class_2561)class_52502, n, removeY + (20 - 9) / 2, -1);
        }
        if (contentHeight > visibleHeight) {
            int scrollbarHeight = Math.max(32, (int)((float)visibleHeight / (float)contentHeight * (float)visibleHeight));
            int scrollbarY = listY + (int)(this.scrollPosition / (float)maxScroll * (float)(visibleHeight - scrollbarHeight));
            int scrollbarX = this.field_22789 - 6 - 4;
            context.method_25294(scrollbarX, listY, scrollbarX + 6, visibleBottom, -14540254);
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -5592406);
        }
        context.method_51433(this.field_22793, "Current Forbidden Entries:", 20, 115, -22016, false);
    }
}

